/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils.log;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.Level;
import com.queplix.core.modules.services.utils.log.impl.BaseLogPublisher;

/**
 * System e-mail log publisher.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.2 $ $Date: 2006/01/24 20:30:20 $
 */

public class SystemLogPublisher
    extends BaseLogPublisher {

    // ========================================================== Initialization

    /**
     * Constructor.
     * @param ls logon session
     */
    public SystemLogPublisher( LogonSession ls ) {
        super( ls );
    }

    // ========================================================== Public methods

    /* (non-Javadoc)
     * @see AbstractLogPublisher#ERROR(String)
     */
    public final void ERROR( String message ) {
        ERROR( message, null );
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#WARN(String)
     */
    public final void WARN( String message ) {
        WARN( message, null );
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#INFO(String)
     */
    public final void INFO( String message ) {
        INFO( message, null );
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#DEBUG(String)
     */
    public final void DEBUG( String message ) {
        DEBUG( message, null );
    }

    /**
     * Logs an error message.
     * @param message message to log
     * @param accountId POP3 acoount ID
     */
    public final void ERROR( String message, Long accountId ) {
        publish( message, accountId, Level.ERROR );
    }

    /**
     * Logs a warning.
     * @param message message to log
     * @param accountId POP3 acoount ID
     */
    public final void WARN( String message, Long accountId ) {
        publish( message, accountId, Level.WARNING );
    }

    /**
     * Logs an informational message.
     * @param message message to log
     * @param accountId POP3 acoount ID
     */
    public final void INFO( String message, Long accountId ) {
        publish( message, accountId, Level.INFO );
    }

    /**
     * Logs a debug message.
     * @param message message to log
     * @param accountId POP3 acoount ID
     */
    public final void DEBUG( String message, Long accountId ) {
        publish( message, accountId, Level.DEBUG );
    }

    // ========================================================== Friend methods

    void publish( String message, Long accountId, Level level ) {

        LogonSession ls = getLogonSession();
        long processID = getProcessID();
        SystemLogRecord lr = new SystemLogRecord( ls, level, message, processID, accountId );
        publish( lr );
    }
}
