/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Temporary attachment JEO handler.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:47 $
 */
public class AttachmentTempObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "attachment.tmp";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return AttachmentTempObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the temporary attachment by its primary key.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param pkey permission ID to search by
     * @return temporary attachment JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByPkey( JEOManagerLocal jeoManager, LogonSession ls, long pkey )
        throws EQLException {

        String eql =
            "select attachment.tmp.* where attachment.tmp.temp_attach_id = " + pkey;

        List hndList = jeoManager.select( ls, AttachmentTempObjectHandler.class, eql );
        if( hndList != null ) {
            return( JEObjectHandler ) hndList.get( 0 );
        } else {
            return null;
        }
    }

    /**
     * Gets the temporary attachments spawned by the same process.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param processID process ID to filter attachments
     * @return JEO handlers list, or <code>null</code> if none found
     * @throws EQLException
     */
    public static List selectByProcessID( JEOManagerLocal jeoManager, LogonSession ls, long processID )
        throws EQLException {

        String eql = "select attachment.tmp.* where attachment.tmp.process_id = " + processID;

        return jeoManager.select( ls, AttachmentTempObjectHandler.class, eql );
    }

}
