/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import java.text.MessageFormat;
import java.util.List;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

/**
 * Chart JEO handler.
 *
 * @author Michael Trofimov
 */
public class ChartObjectHandler
    extends JEObjectHandler {

    private static final String ENTITY = "chart";
    private static final String SQL_SELECT_BY_ID = "select {0}.* where {0}.chart_id = {1}";
    private static final String SQL_SELECT_SYSTEM = "select {0}.* where {0}.system_chart = 1 order by {0}.chart_id";

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return ENTITY;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return ChartObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the chart JEO handler by ID.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param id report ID to search by
     * @return chart JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByID(
            JEOManagerLocal jeoManager, LogonSession ls, long id) throws EQLException {

        String eql = MessageFormat.format(
                SQL_SELECT_BY_ID, new Object[] {ENTITY, id});
        List hndList = jeoManager.select(ls, ChartObjectHandler.class, eql);
        return hndList != null ? (JEObjectHandler) hndList.get(0) : null;
    }

    /**
     * Gets chart JEO by ID.
     * @throws EQLException
     */
    public static ChartObject findByID(
            JEOManagerLocal jeoManager, LogonSession ls, long id) throws EQLException {

        return getJEObject(selectByID(jeoManager, ls, id), ChartObject.class);
    }

    public static List<ChartObject> findSystemCharts(
            JEOManagerLocal jeoManager, LogonSession ls) throws EQLException {

        String eql = MessageFormat.format(
                SQL_SELECT_SYSTEM, new Object[] {ENTITY});
        List hndList = jeoManager.select(ls, ChartObjectHandler.class, eql);
        
        return getJEObjectList(hndList, ChartObject.class);
    }

}