/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * Formset JEO handler.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.2 $ $Date: 2005/09/26 17:53:24 $
 * @deprecated obsolete object
 */
public class FormsetObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "formset";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return FormsetObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the formset by the form name and parent permission ID.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param formName form name to search by
     * @param permissionID parent permission ID to search by
     * @return formset JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler
        selectByFormAndPermission( JEOManagerLocal jeoManager,
                                   LogonSession ls,
                                   String formName,
                                   long permissionID )
        throws EQLException {

        String eql =
            "select /* pageSize=1 */ formset.* where formset.form_id = '"
            + formName
            + "' and formset.permission_id = "
            + permissionID;

        List hndList = jeoManager.select( ls, FormsetObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }

    /**
     * Gets the formsets by the security role and form names list.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param roleID security role ID to search by
     * @param formName form name
     * @return formset JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler
        selectByRoleAndForm( JEOManagerLocal jeoManager,
                             LogonSession ls,
                             long roleID,
                             String formName )
        throws EQLException {

        String eql =
            "select formset.* where permission.security_id = "
            + roleID
            + " and formset.form_id = '"
            + formName
            + "'";

        List hndList = jeoManager.select( ls, FormsetObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }

}
