/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * .
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class InboxObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "inbox";
    } // getEntityName() : String

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return InboxObject.class;
    } // getObjectClass() : Class

    // ============================================================= EQL methods

    /**
     * Gets the inbox message by its primary key.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param pkey search key
     * @return inbox JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByPkey(JEOManagerLocal jeoManager, LogonSession ls, long pkey)
        throws EQLException {

        String eql = "select inbox.* where inbox.pkey = " + pkey;
        List hndList = jeoManager.select(ls, InboxObjectHandler.class, eql);
        if (hndList != null) {
            return (JEObjectHandler)hndList.get(0);
        } else {
            return null;
        } // if (hndList != null)
    } // selectByPkey(JEOManagerLocal, LogonSession, long) : JEObjectHandler

    /**
     * Gets the inbox messages by linked object.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param objectId -and-
     * @param objectType (optional) - linked obj key
     * @return List of inbox JEO handlers
     * @throws EQLException
     */
    public static List selectByLinkObj(
            JEOManagerLocal jeoManager,
            LogonSession ls,
            long objectId,
            Integer objectType
    ) throws EQLException {

        String eql = "select inbox.* where inbox.object_id = " + objectId;
        if (objectType != null) {
            eql += " and inbox.object_type = " + objectType +
                    " order by inbox.received_date desc";
        }
        return jeoManager.select(ls, InboxObjectHandler.class, eql);
    } // selectByLinkObj(JEOManagerLocal, LogonSession, long, Integer) : List
} // class InboxObjectHandler extends JEObjectHandler
