/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.jeo.JEObject;

import java.util.Date;

/**
 * Scheduled report JEO interface.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.2 $ $Date: 2006/08/24 16:21:58 $
 */
public interface ReportSchedulerObject extends JEObject {

    Long getReport_sched_id();
    Long getReport_id();
    Integer getPeriod();
    Integer getPeriod_unit();
    Integer getActive();
    Long getCreated_by();
    Integer getCreator_type();
    Date getNext_date();
    String getTo_addr();
    String getCc_addr();
    String getSubject();
    // NRA code: method to get data from additional column Report_format
    // SE specific. Call this method only if you are sure that corresponding column exists in table QX_REPORT_SCHED
    String getReport_format();
    // end NRA code
    void setNext_date(Date d);


}
