/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.jeo.JEObject;

/**
 * Access right JEO interface.
 * 
 * <p>
 * This class has no setters by design.
 * The rights entity is based on the database view, not on a table, so any data 
 * modification on it is prohibited. 
 * </p>
 * 
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $ 
 */
public interface RightObject extends JEObject {

    String getPkey();
    Long getSecurity_id();
    Long getPermission_id();
    String getFocus_id();
    String getTab_id();
    String getForm_id();
    Integer getAccess_level();

}
