/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.config.utils.EntityHelper;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

public class ViewObjectsObjectHandler extends JEObjectHandler {

    public final static String ENTITY_NAME = "view_objects";
    
    @Override
    public String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public Class getObjectClass() {
        return ViewObjectsObject.class;
    }
    
    public static ViewObjectsObject selectByPkey(
            JEOManagerLocal manager, LogonSession ls, Long pkey) throws EQLException {

        String eql = "select view_objects.* where view_objects.pkey = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(pkey));

        List hndList = manager.select(ls, ViewObjectsObjectHandler.class, stat, eql);
        if(hndList == null || hndList.size() == 0)
            return null;

        JEObjectHandler hnd = (JEObjectHandler) hndList.get(0);
        return (ViewObjectsObject) hnd.getJEObject();
    }
    
    public static List<ViewObjectsObject> selectByFocus(
            JEOManagerLocal manager, LogonSession ls, String focusName) throws EQLException {

        String eql = "select view_objects.* where view_objects.name = ? or view_objects.name like ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(focusName));
        stat.setObject(2, EQLObject.getInstance(
                focusName + EntityHelper.FORM_NAME_SEPARATOR + "%"));

        List hndList = manager.select(ls, ViewObjectsObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<ViewObjectsObject> viewObjects = new ArrayList<ViewObjectsObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            viewObjects.add((ViewObjectsObject) hnd.getJEObject());
        }
        return viewObjects;
    }

    public static List<ViewObjectsObject> selectBySubFocus(
            JEOManagerLocal manager, LogonSession ls, String subFocusName) throws EQLException {
        return selectByFocus(manager, ls, EntityHelper.getParentFocusName(subFocusName));
    }
        
    public static List<ViewObjectsObject> selectByTab(
            JEOManagerLocal manager, LogonSession ls, String tabName) throws EQLException {
        return selectBySubFocus(manager, ls, EntityHelper.getParentSubFocusName(tabName));
    }
        
    public static List<ViewObjectsObject> selectByForm(
            JEOManagerLocal manager, LogonSession ls, String formName) throws EQLException {
        return selectByTab(manager, ls, EntityHelper.getParentTabName(formName));
    }
        
}
