/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.security;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.security.jxb.LoginConfig;
import com.queplix.core.utils.dao.AbstractPropertyFactory;
import com.queplix.core.utils.StringHelper;

/**
 * <p>Factory class for working with login modules</p>
 * @author [AZ] Andrei Zudin
 * @version $Revision: 1.1 $ $Date: 2007/04/12 14:03:51 $
 */

public class LoginModuleFactory
    extends AbstractPropertyFactory {

// ----------------------- VARIABLES -----------------------

    // Single instance.
    private static final LoginModuleFactory o = new LoginModuleFactory();
    
    // Config file name.
    private static final String CONFIG_FILE = "loginmodule.xml";
    
    // Login Module instance
    private LoginModule loginModule;
    
    // XML login config
    private LoginConfig loginConfig;


    // =============================================================== Constructor

    private LoginModuleFactory() {
        try {
         
            // Init LoginConfig XML config.
            loginConfig = ( LoginConfig ) loadSysPropertiesAsObject( CONFIG_FILE, LoginConfig.class );
            
            //
            // Initialization
            //
            
            String className = loginConfig.getLoginmodule().getLoginmoduleclass();
            Class loginModuleClass = null;
            if (className != null && !StringHelper.isEmpty( className )) {
                loginModuleClass = initClass( className );
            }
            else {
                throw new NullPointerException( "LoginModuleFactory#: 'loginmodulename' is NULL" );
            }
            
            // Instantiating LoginModule.
            try {
                loginModule = ( LoginModule ) loginModuleClass.newInstance();
            } catch( Exception ex ) {
                ERROR( ex );
                throw new GenericSystemException( "Cannot instantiate LoginModule. " +
                                                  "Class: " + loginModuleClass.getName(), ex );
            }

        } catch( Exception e ) {
            ERROR( e );
            throw new GenericSystemException( "Cannot init Login Module: " + e.getMessage(), e );
        }
    }
    
//  =============================================================== Public methods

    /**
     * Login Module instance getter.
     * @return LoginModule object
     */
    public LoginModule getLoginModule() {
        return loginModule;
    }
    
    /**
     * Get single instance
     * @return LoginModuleFactory object
     */
    public static LoginModuleFactory getInstance() {
        return o;
    }
}
