/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.ejb;

import com.queplix.core.modules.services.utils.log.AbstractLogRecord;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.async.JMSClient;
import com.queplix.core.utils.ejb.AbstractSessionEJB;

import javax.jms.DeliveryMode;

/**
 * Log manager session EJB.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:59 $
 */

public class LogManagerEJB
    extends AbstractSessionEJB {

    // ----------------------------------------------------- variables

    private LogClient logClient;

    // ----------------------------------------------------- public methods

    /** Initializes bean. */
    public void ejbCreate() {
        INFO( "LogManager EJB created - " + hashCode() );
        logClient = new LogClient();
    }

    /**
     * Send LOG message
     * @param lr given LOG message
     */
    public void sendMessage( AbstractLogRecord lr ) {
        logClient.send( lr );
    }

    // ----------------------------------------------------- innser class

    /**
     * <p>Innser class - log client</p>
     * @author [ALB] Baranov Andrey
     * @version 1.0
     */
    public static class LogClient
        extends JMSClient {

        /**
         * Constructor
         */
        public LogClient() {
            super( JNDINames.JmsConnectionFactory, JNDINames.JmsLogQueue );
        }

        /**
         * Sends message to LogMDB
         * @param lr log record to send
         */
        public void send( AbstractLogRecord lr ) {
            doSend( lr );
        }

        private void doSend( AbstractLogRecord lr ) {
            if( getLogger().isDebugEnabled() ) {
                DEBUG( "Sending log record: " + lr );
            }

            // not persistent and alive for 10 sec.
            super.send( false, DeliveryMode.NON_PERSISTENT, 1, 10000, lr );
        }
    }

} // end of class
