/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.ejb;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.services.jxb.Script;
import com.queplix.core.modules.services.jxb.Task;

import java.util.Collection;

/**
 * Script manager EJB remote interface.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:00 $
 */

public interface ScriptManager
    extends javax.ejb.EJBObject {

    Script getScript( int script_id )
        throws java.rmi.RemoteException;

    Script getScript( String scriptName )
        throws java.rmi.RemoteException;

    Task getTask( long task_id )
        throws java.rmi.RemoteException;

    Task getTask( String taskName )
        throws java.rmi.RemoteException;

    Collection getTasks()
        throws java.rmi.RemoteException;

    void updateCache( Script script )
        throws java.rmi.RemoteException;

    void updateCache( Task task )
        throws java.rmi.RemoteException;

    void flushScriptCache( int script_id )
        throws java.rmi.RemoteException;

    void flushTaskCache( long task_id )
        throws java.rmi.RemoteException;

    Collection getAutostartedTasks()
        throws java.rmi.RemoteException;

    Collection getRunTasks()
        throws java.rmi.RemoteException;

    Collection getMaturedTasks()
        throws java.rmi.RemoteException;

    java.io.Serializable startAction( java.io.Serializable action )
        throws java.rmi.RemoteException;

    //
    // Task management
    //

    void readyTask( long task_id, boolean ignoreStatus )
        throws EQLException, java.rmi.RemoteException;

    void runTask( long task_id, boolean ignoreStatus )
        throws EQLException, java.rmi.RemoteException;

    long waitTask( long task_id, boolean ignoreStatus )
        throws EQLException, java.rmi.RemoteException;

    void completeTask( long task_id, boolean ignoreStatus )
        throws EQLException, java.rmi.RemoteException;

    void interruptTask( long task_id, boolean ignoreStatus )
        throws EQLException, java.rmi.RemoteException;

    void reanimateTask( long task_id )
        throws EQLException, java.rmi.RemoteException;

} // end of interface
