/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.error.GenericAppException;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.AbstractLogPublisher;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Mail LOG publisher.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.2 $ $Date: 2006/07/31 14:45:19 $
 */

public final class MailLogPublisher
    extends AbstractLogPublisher {

    // ------------------------------------------------------- Variables

    private Class clazz;

    // ------------------------------------------------------- Constructors

    //
    // Constructor
    //
    public MailLogPublisher( LogonSession ls, Class clazz ) {

        super( ls );

        if( clazz == null ) {
            throw new NullPointerException( "Class is NULL" );
        }

        this.clazz = clazz;
    }

    // ------------------------------------------------------- Public overrided methods

    public void ERROR( String message, Throwable t, String referer ) {

        // checking
        if( t != null ) {
            if( t instanceof GenericAppException ) {
                // application exception - do nothing
                return;
            }
        }

        MailLogRecord lr = new MailLogRecord( getLogonSession(),
                                              Level.ERROR,
                                              message,
                                              t,
                                              clazz,
                                              referer);
        publish( lr );
    }

    public void ERROR( String message ) {
        ERROR( message, null, null );
    }

    public void ERROR( Throwable t ) {
        ERROR( null, t, null );
    }

    public void WARN( String message ) {
        throw new UnsupportedOperationException();
    }

    public void INFO( String message ) {
        throw new UnsupportedOperationException();
    }

    public void DEBUG( String message ) {
        throw new UnsupportedOperationException();
    }
}
