/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.statistics;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.UserLogObject;
import com.queplix.core.modules.jeo.gen.UserLogObjectHandler;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.User;

import java.util.List;

/**
 * Description: Helps to manage user login/logout statistics
 * @author [SVM] Maxim Suponya
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:03 $
 */

public class UserLog {

    /**
     * Gets User's data and puts it into user log table as login
     * @param ls - LogonSession
     */
    public static void login( LogonSession ls ) {

        User user = ls.getUser();

        JEOManagerLocal jeoManager = ( JEOManagerLocal )
            getCacheObjectManager().getLocalObject( JNDINames.JEOManager, JEOManagerLocalHome.class );

        try {
            JEObjectHandler hnd = jeoManager.create( ls, UserLogObjectHandler.class );

            UserLogObject obj = ( UserLogObject ) hnd.getJEObject();
            obj.setUser_type_id(user.getAuthenticationType());
            obj.setUser_id(user.getUserID());
            obj.setSession_id( ls.getSessionID() );
            obj.setFullname( user.getFullName() );
            obj.setHost( ls.getHost() );
            obj.setRemote_address( ls.getRemoteAddress() );
            obj.setLogin_time( DateHelper.getNowDate() );

            hnd.commit();

        } catch( EQLException ex ) {
            throw new GenericSystemException( ex );
        }
    }

    /**
     * Gets User's data and puts it into user log table as logout
     * @param ls - LogonSession
     */
    public static void logout( LogonSession ls ) {

        JEOManagerLocal jeoManager = ( JEOManagerLocal )
            getCacheObjectManager().getLocalObject( JNDINames.JEOManager, JEOManagerLocalHome.class );

        try {
            List hndList = UserLogObjectHandler.selectBySessoinId( jeoManager, ls, ls.getSessionID() );

            if( hndList != null ) {
                JEObjectHandler hnd = ( JEObjectHandler ) hndList.get( 0 );
                UserLogObject obj = ( UserLogObject ) hnd.getJEObject();
                obj.setLogout_time( DateHelper.getNowDate() );

                hnd.commit();
            }

        } catch( EQLException ex ) {
            throw new GenericSystemException( ex );
        }
    }

    /**
     * Cleans all records from user log table
     */
    public static void cleanAll() {
        //TODO: implement it...
    }

    // Get cache object manager
    private static CacheObjectManager getCacheObjectManager() {
        return new CacheObjectManager();
    }
}
