/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * <p>Generic cache</p>
 * @author [ALB] Baranov Andrey
 * @version 1.0
 * @todo Rewrite on OSCache or Turbine JCS
 */

public class GenericCache
    extends AbstractCache {

    // Map to store cached data.
    private Map map;

    //
    // Constructors.
    //

    public GenericCache( int initilSize ) {
//        map = new LinkedHashMap( initilSize );
        map = new HashMap( initilSize );
    }

    public GenericCache() {
//        map = new LinkedHashMap();
        map = new HashMap();
    }

    /*
     * No javadoc
     * @see Cache#get
     */
    public Object get( Object key ) {
        return map.get( key );
    }

    /*
     * No javadoc
     * @see Cache#headMap
     */
    public SortedMap headMap( Comparable toKey ) {
        throw new UnsupportedOperationException();
    }

    /*
     * No javadoc
     * @see Cache#subMap
     */
    public SortedMap subMap( Comparable fromKey, Comparable toKey ) {
        throw new UnsupportedOperationException();
    }

    /*
     * No javadoc
     * @see Cache#tailMap
     */
    public SortedMap tailMap( Comparable fromKey ) {
        throw new UnsupportedOperationException();
    }

    /*
     * No javadoc
     * @see Cache#toMap
     */
    public SortedMap toMap() {
        if( !map.isEmpty() ) {
            return new TreeMap( map );
        } else {
            return null;
        }
    }

    /*
     * No javadoc
     * @see Cache#containsKey
     */
    public boolean containsKey( Object key ) {
        return map.containsKey( key );
    }

    /*
     * No javadoc
     * @see Cache#keys
     */
    public Collection keys() {
        return map.keySet();
    }

    /*
     * No javadoc
     * @see Cache#getLastKey
     */
    public Object getLastKey() {
        throw new UnsupportedOperationException();
    }

    /*
     * No javadoc
     * @see Cache#getFirstKey
     */
    public Object getFirstKey() {
        throw new UnsupportedOperationException();
    }

    /*
     * No javadoc
     * @see Cache#values
     */
    public Collection values() {
        return map.values();
    }

    /*
     * No javadoc
     * @see Cache#put(Object, Object)
     */
    public void put( Object key, Object o ) {
        if( !isOpen() ) {
            throw new IllegalStateException( "Cache closed" );
        }
        map.put( key, o );
    }

    /*
     * No javadoc
     * @see Cache#put(Map)
     */
    public void put( Map _map ) {
        if( !isOpen() ) {
            throw new IllegalStateException( "Cache closed" );
        }
        map.putAll( _map );
    }

    /*
     * No javadoc
     * @see Cache#remove
     */
    public void remove( Object key ) {
        if( !isOpen() ) {
            throw new IllegalStateException( "Cache closed" );
        }
        map.remove( key );
    }

    /*
     * No javadoc
     * @see Cache#clear
     */
    public void clear() {
        super.clear();
        map.clear();
    }

    /*
     * No javadoc
     * @see Cache#isEmpty
     */
    public boolean isEmpty() {
        return map.isEmpty();
    }

    // Get string.
    public String toString() {
        return "GenericCache: keys= " + keys() + "; open=" + isOpen();
    }
}
