/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.dao;

import com.queplix.core.error.GenericSystemException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Get SQL query for DB DAO realization.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/10/26 14:03:51 $
 */
public class DBRealm {

    private String fileName;
    private Properties props;

    /**
     * Constructor.
     * @param fileName property local file name
     */
    public DBRealm( String fileName ) {

        InputStream is = AbstractPropertyFactory.loadSysPropertiesAsStream( getClass(), fileName );

        this.fileName = fileName;
        this.props = new Properties();

        try {
            props.load( is );
        } catch( IOException ex ) {
            throw new GenericSystemException( "Can't load DB realm '" + fileName +
                                              "'", ex );
        }
    }

    /**
     * Get SQL by the <code>name</code>.
     * @param name given name
     * @return SQL string
     */
    public String getSql( String name ) {
        String sql = ( String ) props.get( name );
        if( sql == null ) {
            throw new NullPointerException( "Can't get sql '" + name +
                                            "' from properties '" + fileName + "'" );
        }
        return sql;
    }

    /**
     * Get property by the <code>name</code>.
     * @param name given name
     * @return property string
     */
    public String getProperty( String name ) {
        String property = ( String ) props.get( name );
        if( property == null ) {
            throw new NullPointerException( "Can't get property '" + name +
                                            "' from properties '" + fileName + "'" );
        }
        return property;
    }

}
