/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.sql.vendor.mysql;

import com.queplix.core.utils.StringHelper;
import com.queplix.core.utils.sql.generic.BinaryParserImpl;
import com.queplix.core.utils.sql.generic.FloatParserImpl;
import com.queplix.core.utils.sql.generic.IntParserImpl;
import com.queplix.core.utils.sql.generic.LongParserImpl;
import com.queplix.core.utils.sql.generic.MemoParserImpl;
import com.queplix.core.utils.sql.generic.SqlWrapperImpl;
import com.queplix.core.utils.sql.generic.StringParserImpl;
import com.queplix.core.utils.sql.parser.BinaryParser;
import com.queplix.core.utils.sql.parser.DateParser;
import com.queplix.core.utils.sql.parser.FloatParser;
import com.queplix.core.utils.sql.parser.IntParser;
import com.queplix.core.utils.sql.parser.LongParser;
import com.queplix.core.utils.sql.parser.MemoParser;
import com.queplix.core.utils.sql.parser.StringParser;
import com.queplix.core.utils.sql.parser.TimeParser;
import com.queplix.core.utils.sql.parser.TimestampParser;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Types;

/**
 * Mysql server SQL operations wrapper implementation.
 *
 * @author Sergey Savchuk
 */

public class SqlWrapperMysqlImpl extends SqlWrapperImpl {

    // Parser implementations.
    // Change the generic implementations for database-specific ones, as needed.
    private final IntParserImpl iP = new IntParserImpl();
    private final LongParserImpl lP = new LongParserImpl();
    private final FloatParserImpl fP = new FloatParserImpl();
    private final StringParserImpl sP = new StringParserImpl();
    private final BinaryParserImpl bP = new BinaryParserImpl();
    private final MemoParserImpl mP = new MemoParserImpl();
    private final MemoParserImpl mlP = new MemoParserImpl();
    private final DateParserMysqlImpl dP = new DateParserMysqlImpl();
    private final TimestampParserMysqlImpl tsP = new TimestampParserMysqlImpl();
    private final TimeParserMysqlImpl tP = new TimeParserMysqlImpl();

    protected void throwSQLException(SQLException ex) throws SQLException {

    }

    /* (non-Javadoc)
     * @see SqlWrapper#getIntParser()
     */
    public IntParser getIntParser() {
        return iP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getLongParser()
     */
    public LongParser getLongParser() {
        return lP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getFloatParser()
     */
    public FloatParser getFloatParser() {
        return fP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getStringParser()
     */
    public StringParser getStringParser() {
        return sP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getTimestampParser()
     */
    public TimestampParser getTimestampParser() {
        return tsP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getDateParser()
     */
    public DateParser getDateParser() {
        return dP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getTimeParser()
     */
    public TimeParser getTimeParser() {
        return tP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getMemoParser()
     */
    public MemoParser getMemoParser() {
        return mP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getMemoLongParser()
     */
    public MemoParser getMemoLongParser() {
        return mlP;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getBinaryParser()
     */
    public BinaryParser getBinaryParser() {
        return bP;
    }


    public long getNextSeq(Connection con, String name) throws SQLException {
        /** @todo implement it */
        throw new UnsupportedOperationException();
    }

    public String getSoundex(Connection con, String str) throws SQLException {
        /** @todo implement it */
        throw new UnsupportedOperationException();
    }

    public String getCurrentSchema(Connection con) throws SQLException {
        /** @todo implement it */
        return null;
    }


    /* (non-Javadoc)
    * @see SqlWrapper#getNextKey(Connection, String, int)
    */
    public long getNextKey(Connection con, String table, int range) throws SQLException {
        CallableStatement cs = null;
        table = table.toLowerCase();
        long keyValue;

        // Make SQL query.
        String sql = "{call " + NEXT_KEY_PROC + "(?, ?, ?)}";
        DEBUG("next key sql: " + sql);

        try {
            cs = con.prepareCall(sql);
            cs.setString(1, table);
            cs.setInt(2, range);
            cs.registerOutParameter(3, Types.INTEGER);
            cs.execute();

            keyValue = cs.getLong(3);
            if (cs.wasNull()) {
                keyValue = StringHelper.EMPTY_NUMBER;
            }

        } finally {
            closeConnection(cs);
        }

        // Ok.
        return keyValue;
    }
}
