/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.dao.AbstractPropertyFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * <p>XML factory class</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/10/26 14:03:51 $
 */

public final class XMLFactory {

    // ========================================================== Constants

    // Current class
    private static final Class CLASS = XMLFactory.class;

    private static final String FILE_NAME = "xml.properties";
    private static final String XML_WRAPPER_CLASS = "xmlwrapper.class";
    private static final String TRANSLET_WRAPPER_CLASS = "transletwrapper.class";
    private static final String XML_BINDING_CLASS_NAME = "xmlbinding.class";

    private static final Properties props = new Properties();
    static {
        InputStream is = AbstractPropertyFactory.loadSysPropertiesAsStream( CLASS, FILE_NAME );
        try {
            props.load( is );
        } catch( IOException ex ) {
            ex.printStackTrace();
            throw new GenericSystemException( ex );
        }
    }

    // ========================================================== Public methods

    /**
     * XMLWrapper instance getter.
     * @return new XMLWrapper object
     */
    public static XMLWrapper getXMLWrapper() {
        try {
            String className = props.getProperty( XML_WRAPPER_CLASS );
            return( XMLWrapper ) Class.forName( className ).newInstance();
        } catch( Exception ex ) {
            throw new GenericSystemException( "Can't load class '" + XML_WRAPPER_CLASS +
                                              "' from file '" + FILE_NAME + "'", ex );
        }
    }

    /**
     * TransletWrapper instance getter.
     * @return new TransletWrapper object
     */
    public static TransletWrapper getTransletWrapper() {
        try {
            String className = props.getProperty( TRANSLET_WRAPPER_CLASS );
            return( TransletWrapper ) Class.forName( className ).newInstance();
        } catch( Exception ex ) {
            throw new GenericSystemException( "Can't load class '" + TRANSLET_WRAPPER_CLASS +
                                              "' from file '" + FILE_NAME + "'", ex );
        }
    }

    /**
     * XMLBinding instance getter.
     * @return new XMLBinding object
     */
    public static XMLBinding getXMLBinding() {
        try {
            String className = props.getProperty( XML_BINDING_CLASS_NAME );
            return( XMLBinding ) Class.forName( className ).newInstance();

        } catch( Exception ex ) {
            throw new GenericSystemException( "Can't load class '" + XML_BINDING_CLASS_NAME +
                                              "' from file '" + FILE_NAME + "'", ex );
        }
    }

    // ========================================================== Private methods

    /* constructor */
    private XMLFactory() {}
}
