/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml;

import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;

/**
 * XML wrapper interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:25 $
 */
public interface XMLWrapper {

    /**
     * DocumentBuilder object getter.
     *
     * @param validate whether to make validation
     * @return DocumentBuilder object
     */
    DocumentBuilder getDOMParser( boolean validate );

    /**
     * SAXParser object getter.
     *
     * @param validate whether to make validation
     * @return SAXParser object
     */
    SAXParser getSAXParser( boolean validate );

    /**
     * Produces the DOM object from the XML source.
     *
     * @param in byte input stream to read XML from
     * @param validate whether to validate the source
     * @return DOM object
     */
    Document getDocument( InputStream in, boolean validate );

    /**
     * Produces the DOM object from the XML source.
     *
     * @param in character input stream to read XML from
     * @param validate whether to validate the source
     * @return DOM object
     */
    Document getDocument( Reader in, boolean validate );

    /**
     * Produces the DOM object from the XML file.
     *
     * @param f given file
     * @param validate whether to validate the source
     * @return DOM object
     */
    Document getDocument( File f, boolean validate );
}
