/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml.impl.v26;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.dao.AbstractPropertyFactory;
import com.queplix.core.utils.xml.AbstractTransletWrapper;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

/**
 * Translet (XSLT transformation) wrapper implementation for JAXP
 * @author Sultan Tezadov
 */
public class JaxpTransletWrapper extends AbstractTransletWrapper {
    
    public void transform(Source source, Result result, String transletName, Map params) {
        TransformerFactory factory = TransformerFactory.newInstance();
        InputStream xsltInputStream = AbstractPropertyFactory.loadResourceAsStream(
                JaxpTransletWrapper.class, transletName);
        try {
            Transformer t = factory.newTransformer( new StreamSource( xsltInputStream ) );
            
            // Add XSLT global parameters
            t.clearParameters();
            if( params != null ) {
                Iterator it = params.keySet().iterator();
                while( it.hasNext() ) {
                    String key = ( String ) it.next();
                    Object value = params.get( key );
                    t.setParameter( key, value );
                }
            }
            
            t.transform(source, result);
        } catch (TransformerException ex) {
            throw new GenericSystemException( "Transformer exception: " + ex.getMessage(), ex );
        }
    }
    
}
