/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml.impl.v26;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import java.io.File;

/**
 * <p>Xalan translet compiler ANT task</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:27 $
 */

public class XalanTransletCompiler
    extends Task {

    // Hardcoded: Set XSLTC's TransformerFactory implementation as the default
    static {
        System.setProperty( "javax.xml.transform.TransformerFactory",
                            "org.apache.xalan.xsltc.trax.TransformerFactoryImpl" );
    }

    // ----------------------------------------------------- variables

    private String xsl;
    private String transletName;
    private String destinationDir;
    private String packageName;

    // ----------------------------------------------------- public methods

    //
    // Setters.
    //

    public void setXsl( String s ) {
        if( s == null ) {
            throw new BuildException( "XSL file name is NULL" );
        }
        xsl = s;
    }

    public void setTransletName( String s ) {
        if( s == null ) {
            throw new BuildException( "Translet name is NULL" );
        }
        transletName = s;
    }

    public void setDestinationDir( String s ) {
        if( s == null ) {
            throw new BuildException( "Destination directory is NULL" );
        }
        destinationDir = s;
    }

    public void setPackageName( String s ) {
        if( s == null ) {
            throw new BuildException( "Package name is NULL" );
        }
        packageName = s;
    }

    /* (non-Javadoc)
     * @see org.apache.tools.ant.Task#execute()
     */
    public void execute()
        throws BuildException {

        log( "	Compile XSL '" + xsl + "' to translet" );
        log( "		translet name: " + transletName );
        log( "		destination directory: " + destinationDir );
        log( "		package name: " + packageName );

        File xslFile = new File( getProject().getBaseDir(), xsl );
        if( !xslFile.exists() || !xslFile.isFile() ) {
            throw new BuildException( "Bad XSL file: " + xslFile.getAbsolutePath() );
        }
        File destinationDirFile = new File( getProject().getBaseDir(), destinationDir );
        if( !destinationDirFile.exists() || !destinationDirFile.isDirectory() ) {
            throw new BuildException( "Bad destination dir: " + destinationDirFile.getAbsolutePath() );
        }

        try {
            // Get an input stream for the XSL stylesheet
            StreamSource stylesheet = new StreamSource( xslFile );

            // The TransformerFactory will compile the stylesheet and
            // put the translet classes inside the Templates object
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute( "translet-name", transletName );
            factory.setAttribute( "destination-directory", destinationDirFile.getAbsolutePath() );
            factory.setAttribute( "package-name", packageName );
            factory.setAttribute( "generate-translet", Boolean.TRUE );
            Templates templates = factory.newTemplates( stylesheet );

            log( "	Ok. Templates: " + templates.toString() );

        } catch( Exception e ) {
            throw new BuildException( e );
        }
    }
}
