/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.rpc;

import com.google.gwt.user.client.rpc.RemoteService;
import com.queplix.core.client.app.vo.AccumulatedEntitiesRequestObject;
import com.queplix.core.client.app.vo.AccumulatedEntityDataResponse;
import com.queplix.core.client.app.vo.AdhocPrintRequestObject;
import com.queplix.core.client.app.vo.AdhocSearchGridRecordsRequest;
import com.queplix.core.client.app.vo.BaseGridRequest;
import com.queplix.core.client.app.vo.CustomizeGridRequestObject;
import com.queplix.core.client.app.vo.ClearEntityRequestObject;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;
import com.queplix.core.client.app.vo.EmailComposeResponseObject;
import com.queplix.core.client.app.vo.EntityDataResponseObject;
import com.queplix.core.client.app.vo.EntityDeleteRequestObject;
import com.queplix.core.client.app.vo.EntityIDRequestObject;
import com.queplix.core.client.app.vo.EntityUpdateRequestObject;
import com.queplix.core.client.app.vo.EntityUpdateResponseObject;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.FormatDataRequestObject;
import com.queplix.core.client.app.vo.FormatDataResponseObject;
import com.queplix.core.client.app.vo.LoadReportResponseObject;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.MoreDataResponseObject;
import com.queplix.core.client.app.vo.NewEntityRequestObject;
import com.queplix.core.client.app.vo.ParseDateRequestObject;
import com.queplix.core.client.app.vo.ParseDateResponseObject;
import com.queplix.core.client.app.vo.PrintFormRequestObject;
import com.queplix.core.client.app.vo.PrintGridRequestObject;
import com.queplix.core.client.app.vo.SaveAdhocReportRequestObject;
import com.queplix.core.client.app.vo.SavedSearchDeleteRequestObject;
import com.queplix.core.client.app.vo.SavedSearchObject;
import com.queplix.core.client.app.vo.SearchGridRecordsResponseObject;
import com.queplix.core.client.app.vo.AdhocDeleteReportRequest;

/**
 * Provides all data exchange with the server.
 * @author Sultan Tezadov
 */
public interface DataService extends RemoteService {
    public SearchGridRecordsResponseObject searchWithMultipleFormConstraints(AccumulatedEntitiesRequestObject multipleFormSearchRequest) throws RPCException;
    public AccumulatedEntityDataResponse getEntityData(EntityIDRequestObject entityDataRequest) throws RPCException;
    public AccumulatedEntityDataResponse getLockForEditRecord(EntityIDRequestObject entityDataRequest) throws RPCException;
    public AccumulatedEntityDataResponse unlockAfterEditRecord(EntityIDRequestObject entityDataRequest) throws RPCException;
    public EntityUpdateResponseObject updateRecord(EntityUpdateRequestObject updateRequest) throws RPCException;
    public EntityUpdateResponseObject insertRecord(EntityUpdateRequestObject updateRequest) throws RPCException;
    public EntityDataResponseObject createEntity(NewEntityRequestObject request) throws RPCException;
    public MoreDataResponseObject getMoreData(FieldDataRequest request) throws RPCException;
    public void printForm(PrintFormRequestObject printRequest) throws RPCException;
    public void printGrid(PrintGridRequestObject printRequest) throws RPCException;
    public void saveSearch(SavedSearchObject search) throws RPCException;
    public SavedSearchObject[] loadSavedSearches() throws RPCException;
    public ParseDateResponseObject parseDate(ParseDateRequestObject parseRequest) throws RPCException;
    public FormatDataResponseObject formatDate(FormatDataRequestObject request) throws RPCException;
    public void customizeGrid(CustomizeGridRequestObject request) throws RPCException;
    public SearchGridRecordsResponseObject customEntitiesFieldsSearch(AdhocSearchGridRecordsRequest request) throws RPCException;
    public void customEntitiesFieldsReport(AdhocPrintRequestObject request) throws RPCException;
    public void saveReport(SaveAdhocReportRequestObject request) throws RPCException;
    public SearchGridRecordsResponseObject loadReports(BaseGridRequest request) throws RPCException;
    public LoadReportResponseObject loadReport(EntityIDRequestObject request) throws RPCException;
    public SearchGridRecordsResponseObject deleteReport(AdhocDeleteReportRequest reportId) throws RPCException;
    public void deleteRecord(EntityDeleteRequestObject request) throws RPCException;
    public void saveSettings(MetaData metaData) throws RPCException;
    public void deleteSavedSearch(SavedSearchDeleteRequestObject request) throws RPCException;
    public AccumulatedEntityDataResponse clearEntity(ClearEntityRequestObject request) throws RPCException;
    public EmailComposeResponseObject sendEmail(EmailComposeRequestObject request) throws RPCException;
}
