/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * MainFrameReportDesignEvent.java
 *
 *  1  2006 ., 15:28
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.queplix.core.client.common.crossframes;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldMeta;

/**
 * This class to be used when send event from MainFrame to Application when adhoc report event occured.
 * @author aliaksandr.melnik
 * @author Sergey Kozmin
 */
public class AdhocData {
    private FamgMeta.Index formIndex;
    private FieldMeta fieldSent;
    /**
     * parameter elementDesignReportData is responsible for representation of field icon on the form in design report mode.
     */
    private int elementDesignReportData;

    public AdhocData() {
    }

    public AdhocData(FamgMeta.Index formIndex, FieldMeta fieldSent, int elementDesignReportData) {
        this.formIndex = formIndex;
        this.fieldSent = fieldSent;
        this.elementDesignReportData = elementDesignReportData;
    }

    public FamgMeta.Index getFormIndex() {
        return formIndex;
    }

    public void setFormIndex(FamgMeta.Index formIndex) {
        this.formIndex = formIndex;
    }

    public FieldMeta getFieldSent() {
        return fieldSent;
    }

    public void setFieldSent(FieldMeta fieldSent) {
        this.fieldSent = fieldSent;
    }

    public int getElementDesignReportData() {
        return elementDesignReportData;
    }

    public void setElementDesignReportData(int elementDesignReportData) {
        this.elementDesignReportData = elementDesignReportData;
    }

    public boolean equals(Object obj) {
        if(!(obj instanceof AdhocData)) {
            return false;
        } else {
            AdhocData el = (AdhocData) obj;
            return fieldSent.getFieldID().equalsIgnoreCase(el.fieldSent.getFieldID()) && el.formIndex.equals(formIndex);
        }
    }

    public int hashCode() {
        return formIndex.hashCode();
    }

    public AdhocData cloneElement() {
        return new AdhocData(formIndex, fieldSent.cloneElementMeta(), elementDesignReportData);
    }
}
