/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.event;

import com.google.gwt.user.client.ui.Widget;

/**
 * Event class. It's neither thread safe nor support simultaneously having
 * multiple instances of the same event with different data. If such need
 * arises, it's an indication of that you actually need different event 
 * instances. 
 * @author Sultan Tezadov
 * @since 26 Nov 2006
 */
// TODO: once generics enabled, remove all occurences of '/*]' and '[*/'
public class Event/*]<T>[*/ {
    private /*]/*[*/Object/*]*[*//*]/[*//*] T[*/ data;
    private boolean userGenerated;
    
    public Event() {
    }

    public Event(/*]/*[*/Object/*]*[*//*]/[*//*] T[*/ data) {
        this.data = data;
    }

    public /*]/*[*/Object/*]*[*//*]/[*//*] T[*/ getData() {
        return data;
    }

    public void setData(/*]/*[*/Object/*]*[*//*]/[*//*] T[*/ data) {
        this.data = data;
    }    
        
    public boolean equals(Object o) {
        if (o != null && o instanceof Event) {
            if (data != null) {
                return data.equals(((Event)o).getData());
            }
            else {
                return this == o;
            }
        }
        else {
            return false;
        }
    }

    public boolean isUserGenerated() {
        return userGenerated;
    }

    public void setUserGenerated(boolean userGenerated) {
        this.userGenerated = userGenerated;
    }
}
