/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * EventListener.java
 *
 *  26 Nov 2006, 11:16
 */

package com.queplix.core.client.common.event;

import com.google.gwt.user.client.ui.Widget;

/**
 * Interface for classes that need to listen to events.
 * @author Sultan Tezadov
 */
public interface EventListener {
    /**
     * Fired when event occurs.
     * @param event the event occured
     * @param sender the widget that fired the event
     */
    public void onEvent(Event event, Widget sender);
}
