/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.Random;


/**
 * Icon with multiple state icons support.
 * @author Sultan Tezadov
 * @since 30 Nov 2006
 */
public class Icon extends Composite {
    private static final String NONE_IMAGE = "common/none.gif";
    
    protected Widget icon;
    private IconData iconState;
    
    public Icon(IconData iconState) {
        this(iconState, true);
    }
    
    public Icon(IconData iconState, boolean initWidget) {
        if (iconState.isStyle()) {
            icon = new Label(" ");
        } else {
            icon = new Image();
        }
        setIconState(iconState);
        if (initWidget) {
            initWidget(icon);
        }
    }
    
    public IconData getIconState() {
        return iconState;
    }
    
    public void setIconState(IconData iconState) {
        if (iconState == null) {
            throw new IllegalArgumentException("Illegal argument: iconState. Must not be null");
        }
        this.iconState = iconState;
        String s;
        s = iconState.getIcon();
        if ((! iconState.isStyle())  &&  (s == null)) {
            s = NONE_IMAGE;
        }
        setPathOrStyle(s);
        s = iconState.getTitle();
        if (s != null) {
            icon.setTitle(s);
        }
    }
    
    protected void setPathOrStyle(String s) {
        if (s != null) {
            if (iconState.isStyle()) {
                icon.setStyleName(s);
            } else {
                ((Image) icon).setUrl(s);
            }
        }
    }
}
