/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;

/**
 * A Button represented as a clickable icon with multiple state icons support.
 * @author Sultan Tezadov
 * @since 23 Nov 2006
 */
public class IconButton extends Icon implements
        SourcesClickEvents,
        ClickListener,
        MouseListener 
{
    ArrayList listeners;
    private ButtonData buttonState;
    private boolean enabled;
    
    public IconButton(ButtonData buttonState) {
        this(buttonState, true);
    }
    
    public IconButton(ButtonData buttonState, boolean initWidget) {
        super(buttonState, initWidget);
        enabled = true;
        this.buttonState = buttonState;
        listeners = new ArrayList();
        ((SourcesClickEvents) icon).addClickListener(this);
        ((SourcesMouseEvents) icon).addMouseListener(this);
    }
    
    public ButtonData getButtonState() {
        return buttonState;
    }
    
    public void setButtonState(ButtonData buttonState) {
        super.setIconState(buttonState);
        this.buttonState = buttonState;
        setEnabled(this.enabled);
    }
    
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        String path = enabled ? buttonState.getIcon() : buttonState.getDisabledIcon();
        setPathOrStyle(path);
    }
    
    public void addClickListener(ClickListener listener) {
        listeners.add(listener);
    }
    
    public void removeClickListener(ClickListener listener) {
        listeners.remove(listener);
    }
    
    public void onClick(Widget sender) {
        if (enabled) {
            for (int i = 0; i < listeners.size(); i++) {
                ClickListener listener = (ClickListener) listeners.get(i);
                listener.onClick(this);
            }
        }
    }
    
    public void onMouseEnter(Widget sender) {
        if (enabled) {
            setPathOrStyle(buttonState.getBrightIcon());
        }
    }
    
    public void onMouseLeave(Widget sender) {
        if (enabled) {
            setPathOrStyle(buttonState.getIcon());
        }
    }
    
    public void onMouseMove(Widget sender, int x, int y) {
    }
    
    public void onMouseDown(Widget sender, int x, int y) {
    }
    
    public void onMouseUp(Widget sender, int x, int y) {
    }

    /**
     * Programmatically clicks the button.
     */
    public void click() {
        onClick(icon);
    }
    
    protected void initWidget(Widget widget) {
        super.initWidget(widget);
        addStyleName("iconButton");
    }
}
