/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * IconData.java
 *
 *  30 Nov 2006, 11:18
 */

package com.queplix.core.client.common.ui;

/**
 * Data for Icon.
 * @see Icon
 * @author Sultan Tezadov
 */
public class IconData {
    private String icon;
    private String title;
    private boolean style;
    
    public IconData(String icon) {
        this(icon, null);
    }

    public IconData(String icon, String title) {
        this(icon, title, false);
    }
    
    /**
     * Constructor
     * @param icon either path to image or style name depending on the style parameter
     * @param title icon's popup title
     * @param style if true, icon parameter specifies CSS style name, when false -- path to the image
     */
    public IconData(String icon, String title, boolean style) {
        this.icon = icon;
        this.title = title;
        this.style = style;
    }
    
    public String getIcon() {
        return icon;
    }

    public String getTitle() {
        return title;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isStyle() {
        return style;
    }

    public void setStyle(boolean style) {
        this.style = style;
    }

}
