/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.*;
import com.queplix.core.client.common.event.Event;

/**
 * A set of label based buttons. Used in menues, etc.
 * @author Sultan Tezadov
 * @since 27 Nov 2006
 */
public class LabelButtonSet extends ButtonSet implements SourcesMouseEvents {
    public static final String LABELED_BUTTON_STYLE = "labelbuttonset_label_style";
    
    private FocusPanel focusPanel;
    private Panel panel;

    public LabelButtonSet(boolean horizontalLayout) {
        this(horizontalLayout, true);
    }
    
    public LabelButtonSet(boolean horizontalLayout, boolean initWidget) {
        focusPanel = new FocusPanel();
        if (horizontalLayout) {
            panel = new HorizontalPanel();
        } else {
            panel = new VerticalPanel();
        }
        focusPanel.setWidget(panel);
        if (initWidget) {
            initWidget(focusPanel);
        }
    }

    public void addButton(Event event, final ButtonData buttonData) {
        final Label label = new Label(buttonData.getCaption());
        String title = buttonData.getTitle();
        if (title != null) {
            label.setTitle(title);
        }
        if(buttonData.hasCaptionStyle()){
            label.addStyleName(buttonData.getCaptionStyle());
        }
        if(buttonData.hasCaptionHoverStyle()){
            label.addMouseListener(new MouseListenerAdapter(){
                public void onMouseEnter(Widget sender) {
                    if(label.getStyleName().lastIndexOf(buttonData.getCaptionSelectedStyle()) < 0){
                        label.addStyleName(buttonData.getCaptionHoverStyle());
                    }
                }
                public void onMouseLeave(Widget sender) {
                    label.removeStyleName(buttonData.getCaptionHoverStyle());
                }
            });
        }
        label.addStyleName(LABELED_BUTTON_STYLE);
        addButton(event, label);
    }
    
    public void addButton(Event event, SourcesClickEvents widget) {
        super.addButton(event, widget);
        panel.add((Widget) widget);
    }
    
    public void removeAllButtons() {
        panel.clear();
        super.removeAllButtons();
    }
    
    public void removeButton(int index) {
        Event event = super.getEvent(index);
        panel.remove((Widget) getWidget(event));
        super.removeButton(index);
    }
    
    protected Panel getPanel() {
        return focusPanel;
    }

    public void addMouseListener(MouseListener listener) {
        focusPanel.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        focusPanel.removeMouseListener(listener);
    }
}
