/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.common.ui.grid;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.Widget;

/**
 * Interface defines all the actions needed for grid, which has the different implementation in different browsers  
 *
 * @author Sergey Kozmin
 * @since 16.11.2006, 14:22:48
 */
public interface GridElementsStrategy extends SourcesTableEvents {
    /**
     * Past given cell value into the grid cell
     * @param grid grid to be used
     * @param row cell row
     * @param column cell column
     * @param cellValue value to be past
     */
    void setCellValue(Grid grid, int row, int column, String cellValue);
    /**
     * Past the given cell value into the grid cell
     * @param grid grid to be used
     * @param row cell row
     * @param column cell column
     * @param cellValue value to be past
     */
    void setCellValue(Grid grid, int row, int column, Widget cellValue);
    
    /**
     * Set header column width. Header grid has one row.
     * @param grid grid to be use
     * @param column column position where value to be added
     * @param row row position where value to be added
     * @param string value to be set
     * @param sortBy sort order to be set 
     */
    void setHeaderCellValue(Grid grid, int row, int column, String string, Boolean sortBy);

    /**
     * Set header column width. Header grid has one row.
     * @param grid grid to be use
     * @param column column to be resized
     * @param sizeInPixels column width to be set
     * @param delta the resize delta (margin between new width and old width)
     */
    void setHeaderColumnWidth(Grid grid, int column, int sizeInPixels, int delta);

    /**
     * Resize the given column. Do operation with single row. 
     * @param grid grid to be use
     * @param row row to be applied
     * @param column column to be resized
     * @param sizeInPixels column width to be set
     * @param delta the resize delta (margin between new width and old width)
     */
    void setOneRowColumnWidth(Grid grid, int row, int column, int sizeInPixels, int delta);

    /**
     * Resize the given column. Do operation with all rows in grid. 
     * @param grid grid to be use
     * @param column column to be resized
     * @param sizeInPixels column width to be set
     * @param delta the resize delta (margin between new width and old width)
     */
    void setAllRowsColumnWidth(Grid grid, int column, int sizeInPixels, int delta);

    /**
     * This method is to be called after grid was resized and each implementation can perform initialization actions. 
     * @param grid resized grid
     */
    void tableInitialized(Grid grid);
}
