/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui.grid;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.StringUtil;

/**
 * Internet Explorer implementation of {@link GridElementsStrategy}
 * @author Sergey Kozmin
 * @since 16 Nov 2006
 */
public class GridElementsStrategyImplIE extends GridElementsStrategyImpl {
    public void setHeaderCellValue(final Grid grid, final int row, int column, String cellValue, Boolean sortBy) {
        grid.setWidget(row, column, getHeaderCell(column, cellValue, sortBy));
    }
    
    public void setCellValue(final Grid grid, final int row, int column, String cellValue) {
        if (StringUtil.isStringEmpty(cellValue)) {
            grid.setHTML(row, column, "&nbsp;");
        } else {
            grid.setText(row, column, cellValue);
        }
    }

    public void setCellValue(Grid grid, int row, int column, Widget cellValue) {
        grid.setWidget(row, column, cellValue);
    }

    public void setHeaderColumnWidth(Grid grid, int column, int sizeInPixels, int delta) {
        setOneRowColumnWidth(grid, 0, column, sizeInPixels, delta);
    }

    public void setOneRowColumnWidth(Grid grid, int row, int column, int sizeInPixels, int delta) {
        grid.setWidth(StringUtil.pixelToSize(grid.getOffsetWidth() + delta));
        grid.getCellFormatter().setWidth(row, column, StringUtil.pixelToSize(sizeInPixels));
    }

    public void setAllRowsColumnWidth(Grid grid, int column, int sizeInPixels, int delta) {
        setOneRowColumnWidth(grid, 0, column, sizeInPixels, delta);
    }
}
