/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.common.ui.grid;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GridSortListenerCollection {
    private List listeners;

    public GridSortListenerCollection() {
        listeners = new Vector();
    }

    public void add(GridSortListener listener) {
        listeners.add(listener);
    }

    public void remove(GridSortListener listener) {
        listeners.remove(listener);
    }

    public synchronized void fireEvent(SourcesGridSortEvents sender, SortColumn sortColumn) {
        if(listeners.size() > 0) {
            for(Iterator it = listeners.iterator(); it.hasNext();) {
                GridSortListener listener = (GridSortListener) it.next();
                listener.onSort(sender, sortColumn);
            }
        }
    }

}
