/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui.grid;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Hyperlink;

/**
 * @author Sultan Tezadov
 * @since 14 Oct 2006
 */
public class PagerHyperlink extends Hyperlink {
    public static final String STYLE_ENABLED = "grid-Pager_link";
    public static final String STYLE_DISABLED = "grid-Pager_disabledLink";

    private static String DISABLED = "disabled";
    private boolean disabled;

    public boolean isDisabled() {
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        DOM.setAttribute(getElement(), DISABLED, disabled ? DISABLED : null);
        removeStyleName(disabled ? STYLE_ENABLED : STYLE_DISABLED);
        addStyleName(disabled ? STYLE_DISABLED : STYLE_ENABLED);
    }

    public void onBrowserEvent(Event event) {
        if(!disabled)
            super.onBrowserEvent(event);
    }
}
