/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * SortColumn.java
 *
 *  5 Dec 2006, 12:41
 */

package com.queplix.core.client.common.ui.grid;

/**
 * Sort column data.
 * @author v.mikhailitchenko
 */
public class SortColumnImpl implements SortColumn {
    private int columnIndex;
    private Boolean ascending;
    
    public SortColumnImpl() {
    }

    public SortColumnImpl(int columnIndex, Boolean ascending) {
        this.columnIndex = columnIndex;
        this.ascending = ascending;
    }

    public int getColumnIndex() {
        return columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Boolean getAscending() {
        return ascending;
    }

    public void setAscending(Boolean ascending) {
        this.ascending = ascending;
    }
        
    public static Boolean getNextSortOrder(Boolean sortOrder){
        if(sortOrder != null) {
            return (sortOrder.booleanValue() ? new Boolean(false) : null);
        } else {
            return new Boolean(true);
        }
    }
}
