/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * QSingleLineControl.java
 *
 *  17  2007 ., 19:28
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.queplix.core.client.controls;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.common.ui.ButtonData;

/**
 * This is the parent for all elements which always use horizontal layout only 
 * (e.g. Checkbox, MemoView).
 * @author dmitry.antonov
 */
public abstract class QSingleLineElementView extends QFormElementView {
    private static final ButtonData EMPTY = new ButtonData(null, null, "control/info_invisible.gif");

    protected QSingleLineElementView(QFormElementModelImpl model, int layout) {
        super(model, layout);
    }

    public boolean alignableAsHorizontal() {
        return true;
    }
    
    protected void beforeInsertLabel() {
        if (isVerticalLayout()) {
            Panel aligningPanel = new HorizontalPanel();
            aligningPanel.add(new Label());
            aligningPanel.add(new IconButton(EMPTY));
            addToPanel(aligningPanel);
            labelPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            labelPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        }
    }

    public int getCaptionOffsetWidth() {
        return (getColSpan() > 1 && !isVerticalLayout()) ? 0 : super.getCaptionOffsetWidth();
    }
    
    public void setCaptionOffsetWidth(int captionOffsetWidth) {
        if (getCaption().equals("")) {
            captionOffsetWidth = 0;
        }
        super.setCaptionOffsetWidth(captionOffsetWidth);
    }
    
    protected void setClientWidth(String clientWidth) {
        if (getColSpan() > 1 && !isVerticalLayout()) {
            int captionOffsetWidth = getOffsetWidth() - getInfoLabelOffsetWidth() -
                    getButtonWidth() - 2;
            setCaptionOffsetWidth(captionOffsetWidth);
        }
    }
    
    protected abstract int getButtonWidth();
    
    public int getClientWidth() {
        return 0;
    }

}
