/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.datefield;

import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.app.vo.DateFieldMeta;

import java.util.Date;

/**
 * Class represents QDateField widgets component.
 * @author Sergey Kozmin
 * @since 14.09.2006
 */
public class QDateField implements QFormElement {
    private QDateFieldControllerImpl controller;
    private QDateFieldViewImpl view;
    private QDateFieldModelImpl model;

    /**
     * Creates QDateField widget with given paramenters
     * @param dateFieldMeta
     */
    public QDateField(DateFieldMeta dateFieldMeta, int layout) {
        model = new QDateFieldModelImpl(dateFieldMeta);
        view = new QDateFieldViewImpl(model, layout);
        controller = new QDateFieldControllerImpl(view, model);
    }

    public QDateFieldModel getModel() {
        return model;
    }

    public QDateFieldView getView() {
        return view;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }
}
