/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.entitylink;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.app.vo.EntityLinkFieldData;
import com.queplix.core.client.app.vo.EntityLinkOnDemandData;
import com.queplix.core.client.controls.QFormElementControllerImpl;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * @author alexander.epifanov
 */
public class QEntityLinkControllerImpl extends QFormElementControllerImpl implements QEntityLinkController, ClickListener {
    private QEntityLinkModelImpl model;
    private QEntityLinkViewImpl view;

    public QEntityLinkControllerImpl(QEntityLinkModelImpl model, QEntityLinkViewImpl view) {
        this.model = model;
        this.view = view;
        view.addActionListener(this);
    }

    public QFormElementModel getModel() {
        return model;
    }

    public QFormElementView getView() {
        return view;
    }

    public void onClick(Widget sender) {
        switch (view.getViewMode()) {
            case QFormElementView.MODE_SEARCH:
            case QFormElementView.MODE_EDIT: {
                EntityLinkOnDemandData onDemandData = model.getOnDemandData();
                boolean canBeLinked = !(onDemandData == null || onDemandData.getLinkedEntityID().equals(EntityLinkFieldData.EMPTY_VALUE));
                if (canBeLinked) {
                    if (model.getData().getLinkedEntityIDs().contains(onDemandData.getLinkedEntityID())) {//id is already in list, so it is already bound
                        model.removeLinkedEntity(onDemandData.getLinkedEntityID());
                    } else {
                        model.addLinkedEntity(onDemandData.getLinkedEntityID());
                    }
                }
                break;
            }
        }
    }
}
