/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.entityreference;

import com.queplix.core.client.app.vo.EntityReferenceData;
import com.queplix.core.client.app.vo.EntityReferenceMeta;
import com.queplix.core.client.app.vo.EntityReferenceOnDemandData;
import com.queplix.core.client.app.vo.GridMeta;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

/**
 * EntitiLink component data
 *
 * @author Rustem Nizamiev
 * @since 14.09.2006, 19:09:29
 */
class QEntityReferenceModelImpl extends QFormElementModelImpl implements QEntityReferenceModel {
    private GridMeta meta;
    private String referencedEntityName;
    private EntityModelListener modelListener;

    private boolean canShowDialogOnDataCome;

    public QEntityReferenceModelImpl(EntityReferenceMeta meta) {
        setMeta(meta);
        this.meta = meta.getMeta();
        referencedEntityName = meta.getReferencedEntityName();
        setEntityReferenceData(new EntityReferenceData());
    }

    public void fireSelectedEntityChanged() {
        if (modelListener != null) {
            modelListener.selectedEntityChanged();
        }
    }

    public GridMeta getMetaData() {
        return meta;
    }

    protected void fireModelMetaChanged() {
        super.fireModelMetaChanged();
        if (modelListener != null) {
            modelListener.modelMetaChanged();
        }
    }

    protected void fireModelDataChanged() {
        super.fireModelDataChanged();
        if (modelListener != null) {
            modelListener.selectedEntityChanged();
        }
    }

    protected void fireOnDemandModelChanged() {
        super.fireOnDemandModelChanged();
        if (modelListener != null) {
            modelListener.onDemandDataCome();
        }
    }

    public void setCustomModelListener(EntityModelListener modelListener) {
        this.modelListener = modelListener;
    }

    public EntityReferenceMeta getMeta() {
        if (null == super.getBaseMeta()) {
            setMeta(new EntityReferenceMeta());
        }
        return (EntityReferenceMeta) super.getBaseMeta();
    }

    public void setMeta(EntityReferenceMeta meta) {
        super.setBaseMeta(meta);
    }

    public EntityReferenceData getEntityReferenceData() {
        if (null == super.getBaseData()) {
            setEntityReferenceData(new EntityReferenceData());
        }
        return ((EntityReferenceData) super.getBaseData());
    }

    public void setEntityReferenceData(EntityReferenceData data) {
        super.setBaseData(data);
    }

    public EntityReferenceOnDemandData getEntityReferenceOnDemandData() {
        if (null == super.getBaseData()) {
            setEntityReferenceOnDemandData(new EntityReferenceOnDemandData());
        }
        return ((EntityReferenceOnDemandData) super.getFieldOnDemandData());
    }

    public void setEntityReferenceOnDemandData(EntityReferenceOnDemandData data) {
        super.setFieldOnDemandData(data);
    }

    public String getErrorTitle() {
        return "Selected entity is empty.";//only one error allowed
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if (THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
//        QEntityReferenceModel model = (QEntityReferenceModel) sameTypeControlModel;
        //todo implement
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getEntityReferenceData().isEmpty());
    }

    public String getReferencedEntityName() {
        return referencedEntityName;
    }

    public boolean isCanShowDialogOnDataCome() {
        return canShowDialogOnDataCome;
    }

    public void setCanShowDialogOnDataCome(boolean canShowDialogOnDataCome) {
        this.canShowDialogOnDataCome = canShowDialogOnDataCome;
    }

    public boolean isLinkable() {
        return true;
    }

    static interface EntityModelListener {
        public void modelMetaChanged();
        public void selectedEntityChanged();
        public void onDemandDataCome();
    }
}
