/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.form;

/**
 * Chain, that can handle the commands from server
 *
 * @author Sergey Kozmin
 * @since 02.10.2006, 17:56:35
 */
interface ChainUnit {
    public static final int UPDATE_SUCCESSFUL = 0;
    public static final int UPDATE_FAILED = 1;
    public static final int DELETE_SUCCESSFUL = 2;
    public static final int DELETE_FAILED = 3;
    public static final int SEARCH_SUCCESSFUL_SINGLE = 4;
//    public static final int SEARCH_SUCCESSFUL_MULTIPLE = 5;
    public static final int SEARCH_FAILED = 6;
    public static final int LOCK_FOR_EDIT_SUCCESSFUL = 7;
    public static final int LOCK_FOR_EDIT_FAILED = 8;
    public static final int NEW_SUCCESSFUL = 9;
    public static final int NEW_FAILED = 10;

    public boolean isAccepted(int event);
    public void handleEvent(int event) throws IncorrectFormActionPerformed;
    public void removingFromChain();
    public String getName();//todo remove after debug
}
