/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.form;

/**
 * To be thrown when incorrect form state selected 
 *
 * Made runtime, because if somewhere developer uses this form it means he wrote incorrect code. That is not exception to be processed,
 * need to rewrite code. Dev's can't rely on incorrect form state. 
 *
 * @author Sergey Kozmin
 * @since 29.09.2006, 17:18:31
 */
public class IncorrectFormStateSelected extends RuntimeException {
    private int state;

    public IncorrectFormStateSelected(String message, int state) {
        super(message);
        this.state = state;
    }

    public IncorrectFormStateSelected(Throwable cause, int state) {
        super(cause);
        this.state = state;
    }

    public IncorrectFormStateSelected(String message, Throwable cause, int state) {
        super(message, cause);
        this.state = state;
    }

    public int getState() {
        return state;
    }
}
