/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.form;

import com.queplix.core.client.app.vo.FormMeta;
import com.queplix.core.client.common.event.Event;


/**
 * Represents an atomic control that can contain other types of controls
 * {@link com.queplix.core.client.controls.QFormElement}
 * @author Sergey Kozmin
 * @since 21 Sep 2006
 */
public class QForm {
    public static final String CORNERS_IMAGES_PATH = "form/corners/";
    
    public final static String FORM_STYLE_NAME_PREFIX = "form_";

    public final static Event[] DEFAULT_BUTTON_EVENTS = new Event[] {
        QFormController.Events.FORM_SEARCH_BUTTON_EVENT,
        QFormController.Events.FORM_CLEAR_BUTTON_EVENT,
        QFormController.Events.FORM_NEW_BUTTON_EVENT,
        QFormController.Events.FORM_CHANGE_BUTTON_EVENT,
        QFormController.Events.FORM_UPDATE_BUTTON_EVENT
    };

    private QFormControllerImpl controller;
    private QFormModelImpl model;
    private QFormViewImpl view;
    
    public QForm(FormMeta formMeta, int width, int height, int formLayout) {
        model = new QFormModelImpl(formMeta);
        view = new QFormViewImpl(model, formLayout, width, height);
        controller = new QFormControllerImpl(view, model);
    }
    
    public QForm(FormMeta formMeta) {
        model = new QFormModelImpl(formMeta);
        view = new QFormViewImpl(model);
        controller = new QFormControllerImpl(view, model);
    }
    
    public QFormController getFormController() {
        return controller;
    }
    
    public QFormModel getModel() {
        return model;
    }
    
    public QFormView getView() {
        return view;
    }
}
