/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.form;

/**
 * Specify row and column of the control at the form
 *
 * @author Sergey Kozmin
 * @since 27.09.2006, 12:48:45
 */
public class XYConstraint implements QFormPlaceConstraint {
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;

    public XYConstraint(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public XYConstraint(int x, int y) {
        this(x, y, 1, 1);
    }

    public int getConstraintForLayoutType() {
        return QFormLayout.XY_LAYOUT;
    }

    public int getX() {
        return x;
    }

    public int getY() {
        return y;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }
}
