/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.grid;

import com.queplix.core.client.app.vo.GridMeta;

public class QGrid {

    private QGridControllerImpl controller;
    private QGridModelImpl model;
    private QGridViewImpl view;

    /**
     * @param meta      grid meta data
     * @param inPopup   is QGrig lies in popup
     * @param customizable is grid customizable 
     * @param refreshable does grid have "refresh" button.
     * @param hasExtendedSelectionActions does grid have additional arrows with select actions.
     * @param sendConfirmationEvent should controller send confirmation event or select a
     * record without sending confirmation event. If true client code will get confirmation event, and by itself should select a record.
     */
    public QGrid(GridMeta meta, boolean inPopup, boolean customizable, boolean sendConfirmationEvent, boolean refreshable,
                 boolean hasExtendedSelectionActions) {
        model = new QGridModelImpl(meta);
        view = new QGridViewImpl(model, inPopup, customizable, refreshable, hasExtendedSelectionActions, sendConfirmationEvent);
        controller = new QGridControllerImpl(model, view);
    }
            
    /**
     * @param meta      grid meta data
     * @param inPopup   is QGrig lies in popup
     */
    public QGrid(GridMeta meta, boolean inPopup) {
        this(meta, inPopup, false, false, false, false);
    }

    public QGridController getController() {
        return controller;
    }

    public QGridModel getModel() {
        return model;
    }

    public QGridView getView() {
        return view;
    }

}
