/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.grid;

import com.queplix.core.client.app.vo.GridData;
import com.queplix.core.client.app.vo.GridMeta;
import com.queplix.core.client.app.vo.RowData;
import com.queplix.core.client.app.vo.SortField;
import com.queplix.core.client.app.vo.SubsetData;
import com.queplix.core.client.common.ui.grid.SortColumn;

public interface QGridModel {
    public void setGridData(GridData data);
    public void setGridData(GridData data, long recordsTotal, long currentPage);
    public void setMetaData(GridMeta data);
    public void setRowData(RowData data);
    public int getPageSize();
    public boolean isCounterToggledOn();
    public long getCurrentPage();
    public SortField getSortField();
    public SortColumn getSortColumn();//todo remove in future. datagrid should not ask GridModel about sort column.
    public long getRecordsTotal();

    /**
     * @return number of records loaded in grid
     */
    public int getModelRowCount();

    public void customizeGrid(SubsetData data);
    public void setSelectedRecordId(Long recordIDToSelect);
}
