/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.history;

import com.queplix.core.client.controls.QFormElementControllerImpl;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.app.vo.HistoryDataRequest;

import java.util.ArrayList;

/**
 * @author: Melnik Alexander
 * @since: 11.01.2007
 */
class QHistoryControllerImpl extends QFormElementControllerImpl implements QHistoryController, HistoryViewListener {
    private QHistoryModelImpl model;
    private QHistoryViewImpl view;

    private ArrayList dataChangeListeners;

    private HistoryDataRequest request;

    public QHistoryControllerImpl(QHistoryModelImpl model, QHistoryViewImpl view) {
        this.model = model;
        this.view = view;
        this.view.addEventHandler(this);
    }

    public void showDialog() {
        request = new HistoryDataRequest(model.getMeta().getFieldID(), model.getData().getHistoryDbId());
        dataRequestListener.needMoreData(request);
    }

    public void addMemoListener(QHistoryListener listener) {
        if (dataChangeListeners == null) {
            dataChangeListeners = new ArrayList();
        }
        dataChangeListeners.add(listener);
    }

    public void removeMemoListener(QHistoryListener listener) {
        if (dataChangeListeners != null) {
            dataChangeListeners.remove(listener);
        }
    }

    protected void fireMemoDataChanged() {
        if (dataChangeListeners != null) {
            for (int i = 0; i < dataChangeListeners.size(); i++) {
                QHistoryListener listener = (QHistoryListener) dataChangeListeners.get(i);
                listener.dataChanged();
            }
        }
    }

    public QFormElementModel getModel() {
        return this.model;
    }
    
    public QFormElementView getView() {
        return this.view;
    }
}
