/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.history;

import com.queplix.core.client.app.vo.HistoryFieldData;
import com.queplix.core.client.app.vo.HistoryFieldMeta;
import com.queplix.core.client.app.vo.HistoryOnDemandData;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

import java.util.ArrayList;

/**
 * @author: Melnik Alexander
 * @since: 11.01.2007
 */
class QHistoryModelImpl extends QFormElementModelImpl implements QHistoryModel {
    private ArrayList changeListeners = new ArrayList();

    public QHistoryModelImpl(HistoryFieldMeta element) {
        setMeta(element);
        setData(new HistoryFieldData());
    }
    
    public HistoryFieldMeta getMeta () {
        if (null == super.getBaseMeta()) {
            setMeta(new HistoryFieldMeta());
        }
        return (HistoryFieldMeta) super.getBaseMeta();
    }
    
    public void setMeta(HistoryFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public HistoryFieldData getData() {
        if(null == super.getBaseData()) {
            setData(new HistoryFieldData());
        }
        return ((HistoryFieldData) super.getBaseData());
    }
        
    public void setData(HistoryFieldData data) {
        setBaseData(data);
    }

    public HistoryOnDemandData getOnDemandData() {
        return (HistoryOnDemandData) getFieldOnDemandData();
    }

    public void addDataChangeListener(QHistoryListener listener) {
        changeListeners.add(listener);
    }
    
    public void removeDataChangeListener(QHistoryListener listener) {
        changeListeners.remove(listener);
    }
    
    protected void fireDataChanged(){
        for (int i = 0; i < changeListeners.size(); i++) {
            QHistoryListener listener = (QHistoryListener) changeListeners.get(i);
            listener.dataChanged();
        }
    }
    
    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }
        
    public int getDataType() {
        return THE_TYPE;
    }
    
    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
        QHistoryModel model = (QHistoryModel) sameTypeControlModel;
        setData((HistoryFieldData) model.getData().cloneData());
    }    

    public boolean isLinkable() {
        return true;
    }
}
