/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.RecordFilter;
import com.queplix.core.client.controls.QFormElementModelImpl;
import com.queplix.core.client.controls.QFormElementView;

import java.util.Collection;
import java.util.List;

public abstract class QInformGridView extends QFormElementView {
    public static interface ViewActionsListener {
        /**
         * Called when action occured.
         * @param actionType type of the action.
         * {@link com.queplix.core.client.controls.informgrid.QInformGrid#ALL_BUTTONS}
         */
        void onAction(int actionType);

        /**
         * Called when search button was pressed on the filtering form
         * @param filter selected on the form filter
         */
        void onSearchRequest(RecordFilter filter);

        /**
         * Called when some control needs more data on the filtering form. 
         * @param dataRequest control data request
         */
        void onMoreDataRequest(FieldDataRequest dataRequest);

        /**
         * Called, when on-demand data is updated by records list
         * @param rows List<RowData>
         * @param filters Collection<FieldData> filters for the string repr
         */
        void addRecordsToModel(List rows, Collection filters);
    }

    protected QInformGridView(QFormElementModelImpl model, int layout) {
        super(model, layout);
    }
}
