/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.app.vo.RecordFilter;

import java.util.List;

/**
 * Interface for in-form grid state controllers 
 *
 * @author Sergey Kozmin
 * @since 06.10.2006, 13:13:56
 */
interface StateContext {
    //enable methods
    void enableLinkButtons();
    void disableLinkButtons();
    void setEnabledUnLinkButton(boolean isEnabled);
    void showLinkButtons();
    void showEnabledFilterButton();
    void hideFilterButton();
    void hideLinkButtons();

    //model works
    void changeState(int newQInformGridState) throws IncorrectGridActionPerformed;

    /**
     * @return {@link com.queplix.core.client.controls.QFormElementView#mode} control mode
     */
    int getControlState();

    /**
     * shows filtering dialog
     */
    void showFilteringDialog();

    RecordFilter getDialogFilter();

    void setFilter(RecordFilter filter);

    void addFilter(RecordFilter filter);

    void showMessage(String msg);

    /**
     * @return List<Integer> of selected indexes
     */
    List getSelectedRecords();

    /**
     * @param records List<Integer> of indexes
     */
    void removeRecords(List records);
}
