/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.listbox;

import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.app.vo.ListboxFieldMeta;
import com.queplix.core.client.app.vo.FieldType;
import com.queplix.core.client.controls.QFormElementModel;

public interface QListBoxModel extends QFormElementModel {
    public static final int THE_TYPE = FieldType.LISTBOX;
    /**
     * Gets the number of items present in the list box.
     *
     * @return the number of items
     */
    public int getItemCount();

    public ListboxFieldData getData();
    public void setData(ListboxFieldData data);

    public boolean isItemSelected(int idx);
    public int getFirstSelectedIdx();

    public void selectFirstItem();

    public ListboxFieldMeta getMeta();
    public void setMeta (ListboxFieldMeta meta);
}
