/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.memo;

import com.queplix.core.client.app.vo.MemoFieldData;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.controls.QFormElementControllerImpl;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

import java.util.ArrayList;

/**
 * @author: Vasily Mikhailitchenko
 * @since: 15.09.2006
 */
class QMemoControllerImpl extends QFormElementControllerImpl implements QMemoController, QMemoEventHandler {
    private QMemoModelImpl model;
    private QMemoViewImpl view;

    private ArrayList dataChangeListeners;

    public QMemoControllerImpl(QMemoModelImpl model, QMemoViewImpl view) {
        this.model = model;
        this.view = view;
        view.addEventHandler(this);
    }

    private void checkSaveText(String newText) {
        MemoFieldData mfd = model.getData();
        String text = StringUtil.nullToEmpty(mfd.getText());
        if (!text.equals(newText)) {
            mfd.setText(newText);
            model.setData(mfd);
        }
    }
    
    public void handleEvent(QMemoEvent event) {
        switch (event.getType()) {
            case QMemoEvent.EVENT_SHOWPOPUP:
                if (!(view.isDisabled() && model.getBaseData().isEmpty()) &&
                    !(view.isSearchMode() && !model.getBaseMeta().isSearchable()) ) {
                    view.showPopup();
                }
                break;
            case QMemoEvent.EVENT_SAVE:
                checkSaveText(view.getText());
                break;
            case QMemoEvent.EVENT_CANCEL:
                view.setText(model.getData().getText());
                break;
        }
    }

    public void addMemoListener(QMemoListener listener) {
        if (dataChangeListeners == null) {
            dataChangeListeners = new ArrayList();
        }
        dataChangeListeners.add(listener);
    }

    public void removeMemoListener(QMemoListener listener) {
        if (dataChangeListeners != null) {
            dataChangeListeners.remove(listener);
        }
    }

    protected void fireMemoDataChanged() {
        if (dataChangeListeners != null) {
            for (int i = 0; i < dataChangeListeners.size(); i++) {
                QMemoListener listener = (QMemoListener) dataChangeListeners.get(i);
                listener.dataChanged();
            }
        }
    }

    public QFormElementModel getModel() {
        return model;
    }
    
    public QFormElementView getView() {
        return view;
    }
    
    public void uploadDataToModel() {
        view.contentChanged();
    }
}
