/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.multiselect;

import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.controls.QFormElementModelImpl;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.OkayCancelPopup;

/**
 * Multi-select view interface
 *
 * @author Rustem Nizamiev
 * @since 14.09.2006, 19:23:32
 */
public abstract class QMultiSelectView extends QFormElementView {
    protected QMultiSelectView(QFormElementModelImpl model, int layout) {
        super(model, layout);
    }

    public static interface Events extends QFormElementView.Events {
        Event ON_DIALOG_DEMAND = new Event();
        Event OK = OkayCancelPopup.Events.OK;
        Event CANCEL = OkayCancelPopup.Events.CANCEL;
    }
}
